pkgname <- "sfislands"
source(file.path(R.home("share"), "R", "examples-header.R"))
options(warn = 1)
options(pager = "console")
library('sfislands')

base::assign(".oldSearch", base::search(), pos = 'CheckExEnv')
base::assign(".old_wd", base::getwd(), pos = 'CheckExEnv')
cleanEx()
nameEx("st_augment")
### * st_augment

flush(stderr()); flush(stdout())

### Name: st_augment
### Title: Augment dataframe with predictions of model
### Aliases: st_augment

### ** Examples

prepdata <- st_bridges(uk_election,"constituency_name")
mgcv::gam(health_not_good ~
  s(constituency_name, bs='mrf', xt=list(nb=prepdata$nb), k=100),
  data=prepdata, method="REML") |>
st_augment(uk_election)



cleanEx()
nameEx("st_bridges")
### * st_bridges

flush(stderr()); flush(stdout())

### Name: st_bridges
### Title: Create first-order queen contiguity neighbourhood structure with
###   additional connections when islands are present, ensuring that there
###   are no unconnected units
### Aliases: st_bridges

### ** Examples

st_bridges(uk_election,"constituency_name")



cleanEx()
nameEx("st_check_islands")
### * st_check_islands

flush(stderr()); flush(stdout())

### Name: st_check_islands
### Title: Examine contiguity actions which have been performed on islands
###   by 'st_bridges()'
### Aliases: st_check_islands

### ** Examples

st_bridges(uk_election,"constituency_name") |>
st_check_islands()



cleanEx()
nameEx("st_force_cut_nb")
### * st_force_cut_nb

flush(stderr()); flush(stdout())

### Name: st_force_cut_nb
### Title: Remove contiguity between pairs of areas
### Aliases: st_force_cut_nb

### ** Examples

# For individual x and y
st_bridges(uk_election,"constituency_name") |>
st_force_cut_nb(x = "Llanelli", y = "Swansea West")

# For multiple x and y pairs
st_bridges(uk_election,"constituency_name") |>
st_force_cut_nb(xy_df = data.frame(
x = c("Llanelli", "Swansea West"),
y = c("Bridgend", "Vale Of Glamorgan")))



cleanEx()
nameEx("st_force_join_nb")
### * st_force_join_nb

flush(stderr()); flush(stdout())

### Name: st_force_join_nb
### Title: Enforce contiguity between pairs of areas
### Aliases: st_force_join_nb

### ** Examples

# For individual x and y
st_bridges(uk_election,"constituency_name") |>
st_force_join_nb(x = "Gower", y = "Bridgend")

# For multiple x and y pairse") |>
st_bridges(uk_election,"constituency_name") |>
st_force_join_nb(xy_df = data.frame(
x = c("Gower", "Llanelli"),
y = c("Bridgend", "Vale Of Glamorgan")))



cleanEx()
nameEx("st_manual_cut_nb")
### * st_manual_cut_nb

flush(stderr()); flush(stdout())

### Name: st_manual_cut_nb
### Title: Manual remove contiguity between two areas
### Aliases: st_manual_cut_nb

### ** Examples

st_bridges(uk_election,"constituency_name") |>
st_manual_cut_nb("Ynys Mon","Arfon") |>
st_manual_cut_nb(292,378)



cleanEx()
nameEx("st_manual_join_nb")
### * st_manual_join_nb

flush(stderr()); flush(stdout())

### Name: st_manual_join_nb
### Title: Manually enforce contiguity between two areas
### Aliases: st_manual_join_nb

### ** Examples

st_bridges(uk_election,"constituency_name") |>
st_manual_join_nb("Gower","St Ives")



cleanEx()
nameEx("st_quickmap_nb")
### * st_quickmap_nb

flush(stderr()); flush(stdout())

### Name: st_quickmap_nb
### Title: Visualise a neighbourhood structure on a map
### Aliases: st_quickmap_nb

### ** Examples

st_bridges(uk_election,"constituency_name") |>
st_quickmap_nb()



cleanEx()
nameEx("st_quickmap_preds")
### * st_quickmap_preds

flush(stderr()); flush(stdout())

### Name: st_quickmap_preds
### Title: Visualise the predictions generated by the 'st_augment()'
###   function
### Aliases: st_quickmap_preds

### ** Examples

prepdata <- st_bridges(uk_election,"constituency_name")
mgcv::gam(health_not_good ~
  s(constituency_name, bs='mrf', xt=list(nb=prepdata$nb), k=100), data=prepdata, method="REML") |>
st_augment(uk_election) |>
st_quickmap_preds()



### * <FOOTER>
###
cleanEx()
options(digits = 7L)
base::cat("Time elapsed: ", proc.time() - base::get("ptime", pos = 'CheckExEnv'),"\n")
grDevices::dev.off()
###
### Local variables: ***
### mode: outline-minor ***
### outline-regexp: "\\(> \\)?### [*]+" ***
### End: ***
quit('no')
