\name{laliga}
\docType{data}
\alias{laliga}

\title{Results of games from La Liga}

\description{
       This data set contains all results for games played
from season 2008/2009 until 2012/2013 of the Spanish La Liga.
}

\usage{laliga}

\format{
  Data is in a data.frame called \code{laliga} with the following columns:

\itemize{
   \item \code{Season}, season when the game was played.
   \item \code{Week}, week of the season where the game was played.
   \item \code{HomeTeam}, name of home team.
   \item \code{AwayTeam}, name of away team.
   \item \code{HomeGoals}, goals scored by home team.
   \item \code{AwayGoals}, goals scored by away team.
}
}

\source{Data have been obtained from \url{http://www.futbolinspain.com/}.}

\examples{
data(laliga)

#Number of games won as local by Real Madrid per season
nrow(laliga[laliga$HomeTeam=="Real Madrid CF" & (laliga$HomeGoals>laliga$AwayGoals),] )

#Highest goal difference
idx<-which.max(abs(laliga$HomeGoals-laliga$AwayGoals))
laliga[idx,]

}

\references{

\url{http://www.futbolinspain.com/}

\url{http://en.wikipedia.org/wiki/La_Liga}

}

\author{Virgilio Gómez-Rubio <virgilio.gomez@uclm.es>}

\keyword{datasets}
