\name{formula1}
\docType{data}
\alias{formula1}

\title{Results of Formula 1 races}

\description{
       This data set contains all results for Formula 1 races from 
   2010 to 2012.
}

\usage{formula1}

\format{
  Data is in a data.frame called \code{laliga} with the following columns:

\itemize{
   \item \code{Pos}, position at the end of the race.
   \item \code{No}, pilot number.
   \item \code{Driver}, driver's name.
   \item \code{Team}, team's name.
   \item \code{Laps}, number of laps completed.
   \item \code{Time}, time to finish or type of problem if the driver retired.
   \item \code{Grid}, starting position.
   \item \code{Pts}, points won.
   \item \code{Season}, year.
}
}

\source{Data have been obtained from \url{http://www.formula1.com}}

\examples{
data(formula1)
#Number of races per driver
table(formula1$Driver)

#Number of races won by driver and season
with(formula1, by(formula1, list(Season, Driver), function(X){sum(X$Pos=="1")}))





}

\references{

\url{http://www.formula1.com}

}

\author{Virgilio Gómez-Rubio <virgilio.gomez@uclm.es>}

\keyword{datasets}
