# Visualization with ggplot2 useR!2013 

plot(iris$Sepal.Width, iris$Sepal.Length)

## Diving in: Scatterplots

install.packages("ggplot2")
library(ggplot2)
?mpg
View(mpg)

qplot(displ, hwy, data = mpg)

## Aesthetics

qplot(displ, hwy, data = mpg, color = class)
qplot(displ, hwy, data = mpg, size = class)
qplot(displ, hwy, data = mpg, shape = class)
qplot(displ, hwy, data = mpg, alpha = class)

## Faceting

qplot(displ, hwy, data = mpg) + facet_grid(. ~ cyl)
qplot(displ, hwy, data = mpg) + facet_grid(drv ~ .)
qplot(displ, hwy, data = mpg) + facet_grid(drv ~ cyl)
qplot(displ, hwy, data = mpg) + facet_wrap(~ class)

## Geoms

qplot(displ, hwy, data = mpg, geom = "smooth")
qplot(displ, hwy, data = mpg, geom = c("point", "smooth"))

qplot(class, hwy, data = mpg, geom = "boxplot")

## Histograms and bar charts

qplot(x, z, data = diamonds)
qplot(x, data  = diamonds)
qplot(cut, data = diamonds)

qplot(displ, data = mpg, binwidth = 1)

qplot(carat, data = diamonds, binwidth = 1)
qplot(carat, data = diamonds, binwidth = 0.1)
qplot(carat, data = diamonds, binwidth = 0.01)
qplot(carat, data = diamonds)

qplot(price, data = diamonds)
qplot(price, data = diamonds, binwidth = 500)
qplot(price, data = diamonds, binwidth = 100)
qplot(price, data = diamonds, binwidth = 50)

qplot(depth, data = diamonds, binwidth = 0.2)
qplot(depth, data = diamonds, binwidth = 0.2, color = cut)
qplot(depth, data = diamonds, binwidth = 0.2, fill = cut)
qplot(depth, data = diamonds, binwidth = 0.2) + 
  facet_wrap(~ cut)
qplot(depth, data = diamonds, geom = "freqpoly", color = cut, 
  binwidth = 0.2) + facet_wrap(~ cut)
qplot(depth, data = diamonds, geom = "freqpoly", 
  color = cut, binwidth = 0.2)
qplot(depth, data = diamonds, geom = "density", 
  color = cut)

qplot(price, data = diamonds, binwidth = 500) + 
  facet_wrap(~ cut)
qplot(price, data = diamonds, binwidth = 500, fill = cut)
qplot(price, data = diamonds, binwidth = 500, 
  geom = "freqpoly", color = cut)
qplot(price, data = diamonds, geom = "density", color = cut)

## Position Adjustments

qplot(color, data = diamonds, fill = cut, position = "stack")
qplot(color, data = diamonds, fill = cut, position = "dodge")
qplot(color, data = diamonds, fill = cut, position = "identity")
qplot(color, data = diamonds, fill = cut, position = "fill")

qplot(cty, hwy, data = mpg)
qplot(cty, hwy, data = mpg, position = "jitter")

## Grammar of Graphics

qplot(date, unemploy, data = economics, geom = "line")
qplot(class, hwy, data = mpg, position = "jitter", color = class)

## Geoms for big data

qplot(carat, price, data = diamonds)
qplot(carat, price, data = diamonds, geom = "bin2d")
# install.packages("hexbin")
qplot(carat, price, data = diamonds, geom = "hex")
qplot(carat, price, data = diamonds, geom = "density2d")
qplot(carat, price, data = diamonds, geom = c("point", "density2d"))
qplot(carat, price, data = diamonds, geom = c("point", "density2d"))

qplot(hwy, data = mpg, geom = "histogram", binwidth = 1)

qplot(carat, price, data = diamonds)
qplot(carat, price, data = diamonds, geom = "smooth")
qplot(carat, price, data = diamonds, geom = "smooth", color = cut)
qplot(carat, price, data = diamonds, geom = "smooth", group = cut)
qplot(carat, price, data = diamonds, geom = "smooth", 
  color = cut, se = FALSE)
qplot(carat, price, data = diamonds, geom = "smooth", 
  color = cut, se = FALSE, method = lm)

qplot(carat, price, data = diamonds, color = cut, 
  geom = c("point", "smooth"))

## Layers

qplot(carat, price, data = diamonds, geom = c("point", "smooth"))
qplot(carat, price, data = diamonds) + geom_smooth()
?geom_smooth

ggplot() + 
  geom_point(aes(x = carat, y = price), 
    data = diamonds) +
  geom_smooth(aes(x = carat, y = price, 
    color = cut), data = diamonds)

ggplot(diamonds, aes(x = carat, y = price)) + 
  geom_point() +
  geom_smooth(aes(color = cut))

ggplot(mpg, aes(displ, cty)) +
  geom_point(aes(color = drv)) +
  geom_smooth()

ggplot(mpg, aes(class, hwy)) +
  geom_point(position = "jitter") +
    geom_boxplot(aes(color = class))

## Customizing graphics

qplot(long, lat, data = borders)
qplot(long, lat, data = borders, geom = "line")
qplot(long, lat, data = borders, geom = "path")
qplot(long, lat, data = borders, geom = "path", group = group)
qplot(long, lat, data = borders, geom = "polygon", group = group)

borders2 <- borders[sample(nrow(borders)), ]  
qplot(long, lat, data = borders2, geom = "polygon", group = group)

borders2 <- borders[sample(nrow(borders)), ]  
qplot(long, lat, data = borders2, geom = "polygon", group = group)
ggplot(borders, aes(long, lat)) + 
  geom_polygon(aes(group = group), fill = NA, color = "grey50")

tx <- qplot(long, lat, data = borders, geom = "polygon", 
            fill = bin, group = group)
tx

## Title

tx + ggtitle("Population of Texas Counties")
tx

tx2 <- tx + ggtitle("Population of Texas Counties")
tx2

## Themes

tx + theme_grey()
tx + theme_bw()

## Coordinate systems

tx + coord_cartesian()
tx + coord_map("mercator")

tx + 
  ggtitle("Population of Texas Counties") +
  theme_bw() +
  coord_map("mercator")

tx + coord_cartesian(xlim = c(-96, -94), ylim = c(29.25, 30.25))

## Scales

qplot(displ, hwy, data = mpg, color = class)
qplot(displ, hwy, data = mpg, color = class) + 
  scale_color_grey()

tx + scale_fill_grey()

p <- qplot(displ, hwy, data = mpg, color = class)
p
p + scale_y_continuous()
p + scale_y_continuous(name = "Highway mpg")
p + scale_y_continuous(breaks = c(15, 20, 25, 30, 35, 40))
p + scale_y_continuous(breaks = c(15, 20, 25, 30, 35, 40),
  labels = c("a", "b", "c", "d", "e", "f"))
p + scale_y_continuous(limits = c(30, 35))

p + scale_color_discrete()

tx + scale_fill_discrete("Population", 
  labels = c("0 - 999", "1,000 - 9,999", 
    "10,000 - 99,999", "100,000 - 999,999", 
    "1,000,000+")) +
  scale_x_continuous("") + 
  scale_y_continuous("")

r <- qplot(displ, cty, colour = drv, shape = fl, data = mpg) 
r + scale_color_manual(values = c("red", "black", "#3333cc"))
r + scale_shape_manual(values = c(0, 15, 1, 16, 3))
?pch

library(RColorBrewer)
RColorBrewer::display.brewer.all()
q + scale_color_brewer(palette="Spectral")
q + scale_color_brewer(palette="Set3")
library(scales)
show_col(brewer_pal(palette = "YlOrRd")(9))

tx + scale_fill_brewer("Population", 
  palette = "Blues",
  labels = c("0 - 999", "1,000 - 9,999", 
    "10,000 - 99,999", "100,000 - 999,999", 
    "1,000,000+")) +
  scale_x_continuous("") + 
  scale_y_continuous("")

## Saving graphics

getwd()


ggsave("my-plot.pdf")
ggsave("my-plot.png")
ggsave("my-plot.pdf", width = 6, height = 6)
